/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.List;
import oracle.cluster.verification.ParamPreReqHAConfig;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.param.Argument;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class HAConfigStage
extends Stage {
    private String m_osdba;
    private String m_oraInv;
    private String m_asmgrp;
    private ParamPreReqHAConfig m_param;

    @Override
    public void init() throws StageInitException {
        super.init();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Inside HAConfigStage:init()...");
        }
        if (this.m_verificationMode == 1) {
            this.m_osdba = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_OSDBA);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            }
            this.m_oraInv = this.m_paramMgr.getSinglePartArgVal(Argument.ARG_GROUP_ORAINV);
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("==== ParamManager reports ORAINV as: " + this.m_oraInv));
            }
            if (this.m_osdba == null) {
                this.m_osdba = VerificationUtil.getDefaultDbaGroup();
            }
            if (this.m_oraInv == null) {
                this.m_oraInv = VerificationUtil.getDefaultOraInvGroup();
            }
            this.m_param = new ParamPreReqHAConfig();
            if (this.m_asmgrp == null) {
                this.m_asmgrp = VerificationUtil.getDefaultAsmGroup();
            }
            this.m_param.setOSDBA(this.m_osdba);
            this.m_param.setOraInv(this.m_oraInv);
        }
    }

    HAConfigStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected boolean checkSetup() {
        ErrorDescription errDesc = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"==== HA Config Stage checkSetup");
        }
        this.setExcludeUserEquiv(true);
        if (!super.checkSetup()) {
            return false;
        }
        if (this.m_verificationMode == 2 && !VerificationUtil.isHAConfigured()) {
            errDesc = new ErrorDescription("4112", s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            this.setValidNodeList(new String[0]);
            return false;
        }
        return this.getValidNodeList() != null;
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"==== HA Config Stage setTaskList");
        }
        if (this.m_verificationMode == 1) {
            List<Task> haConfigStageTaskList = null;
            haConfigStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_HA_CONFIG, this.getValidNodeList(), this.m_param, this);
            this.addToCurrentTaskSet(haConfigStageTaskList.toArray(new Task[0]));
        } else {
            List<Task> haConfigStageTaskList = null;
            haConfigStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.POSTREQ_SI_HA_CONFIG, this.getValidNodeList(), null, this);
            this.addToCurrentTaskSet(haConfigStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

